#include <iostream>
#include <cstring>
using namespace std;

const int MAX_N = 500001;
const int INF = 1e9;

int rooms[MAX_N][2]; // Sobu i njen povezani broj cuvamo u ovom nizu
int jumps[MAX_N];

void findMinimumJumps(int N, int platform[], int change[]) {
    jumps[1] = 0;
    bool updated = true;

    while (updated) {
        updated = false;

        for (int i = 1; i <= N; ++i) {
            if (platform[i] && jumps[i] < jumps.size()) {
                if (jumps[i] > 0) {
                    jumps[i] = 0;
                    updated = true;
                }
            }

            if (change[i]) {
                int next_room = change[i];
                if (jumps[i] + 1 < jumps.size() && jumps[i] + 1 < jumps[next_room]) {
                    jumps[next_room] = jumps[i] + 1;
                    updated = true;
                }
            }

            for (int j = 0; j < 2; ++j) {
                int next_room = rooms[i][j];
                if (next_room != 0 && jumps[next_room] > jumps[i] + 1) {
                    jumps[next_room] = jumps[i] + 1;
                    updated = true;
                }
            }
        }
    }
}

int main() {
    int N;
    cin >> N;

    int platform[MAX_N];
    int change[MAX_N];

    memset(rooms, 0, sizeof(rooms));
    memset(jumps, INF, sizeof(jumps));

    for (int i = 1; i < N; ++i) {
        int U, V;
        cin >> U >> V;
        if (rooms[U][0] == 0) {
            rooms[U][0] = V;
        } else {
            rooms[U][1] = V;
        }
        if (rooms[V][0] == 0) {
            rooms[V][0] = U;
        } else {
            rooms[V][1] = U;
        }
    }

    for (int i = 1; i <= N; ++i) {
        cin >> platform[i];
    }

    for (int i = 1; i <= N; ++i) {
        cin >> change[i];
    }

    findMinimumJumps(N, platform, change);

    for (int i = 1; i <= N; ++i) {
        if (jumps[i] == INF) {
            cout << "-1 ";
        } else {
            cout << jumps[i] << " ";
        }
    }
    cout << endl;

    return 0;
}